/*****************************************************************************
*  LPC4357 RC5 encoder program
*
*  Use SCT timer to send encoded RC5 frames
*  Send frames as long as switch SWP4_0 is pressed
*  SCT_IN0 (pin P2_4) used as dummy input
*  SCT_OUT0 (pin P2_8) used as RC5 output
*****************************************************************************/
#include "nxp_lpc43xx.h"
#include "mcb4300.h"
#include "global.h"

void SysTick_Handler(void)                         // just used to wake-up from sleep mode
{
}

int main (void) 
{
  static uint8_t  trg = 1;
  static uint8_t  tgl = 1;
  static uint16_t frame;

    SystemCoreClockUpdate ();                      // Update system core clock

    LPC_CCU1->CLK_M4_SCT_CFG  = (1 << 0);          // enable SCT clock in CCU1 

    MCB4300_Init();                                // Initialize MCB4300 board stuff
    RC5_Init();
    SysTick_Config(SystemCoreClock/8);             // SysTick interrupt @ 1/8 sec

    while (1)
    {
        frame = (1   << 13) |                      // set start (S) bit
                (1   << 12) |                      // set field (F) bit
                (tgl << 11) |                      // clr control / toggle (C) bit
                (20  << 6 ) |                      // system  = 20
                (9   << 0 );                       // command = 9

        if (!(SWP4_0))                             // SWP4_0 high to low?
        {
            if (trg)
            {
                trg = 0;                           // trigger SWP4_0 low
            }
            RC5_Send(frame);                       // send RC5 frame
        }
        else if ((SWP4_0) && !trg)                 // SWP4_0 low to high?
        {
            trg = 1;                               // trigger SWP4_0 high
            tgl = !tgl;                            // toggle control bit
        }

        __wfi();                                   // goto sleep
    }
}
